/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sqs.model.AWSAccountIdListCopier;
import software.amazon.awssdk.services.sqs.model.ActionNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private final String queueUrl;
    private final String label;
    private final List<String> awsAccountIds;
    private final List<String> actions;

    private AddPermissionRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actions = builder.actions;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String label() {
        return this.label;
    }

    public List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public List<String> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.awsAccountIds() == null ? 0 : this.awsAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.awsAccountIds() == null ^ this.awsAccountIds() == null) {
            return false;
        }
        if (other.awsAccountIds() != null && !other.awsAccountIds().equals(this.awsAccountIds())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        return other.actions() == null || other.actions().equals(this.actions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.awsAccountIds() != null) {
            sb.append("AWSAccountIds: ").append(this.awsAccountIds()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private String label;
        private List<String> awsAccountIds;
        private List<String> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setLabel(model.label);
            this.setAWSAccountIds(model.awsAccountIds);
            this.setActions(model.actions);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAWSAccountIds() {
            return this.awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAWSAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
        }

        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder queueUrl(String var1);

        public Builder label(String var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);
    }
}

