/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.buffered;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.buffered.QueueBuffer;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferConfig;
import software.amazon.awssdk.services.sqs.buffered.ResultConverter;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;

public class SqsBufferedAsyncClient
implements SQSAsyncClient {
    public static final String USER_AGENT = SqsBufferedAsyncClient.class.getSimpleName() + "/" + "2.0.0-preview-4";
    private final CachingMap buffers = new CachingMap(16, 0.75f, true);
    private final SQSAsyncClient realSqs;
    private final QueueBufferConfig bufferConfigExemplar;

    public SqsBufferedAsyncClient(SQSAsyncClient paramRealSqs) {
        this(paramRealSqs, new QueueBufferConfig());
    }

    public SqsBufferedAsyncClient(SQSAsyncClient paramRealSqs, QueueBufferConfig config) {
        config.validate();
        this.realSqs = paramRealSqs;
        this.bufferConfigExemplar = config;
    }

    @Override
    public CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        ResultConverter.appendUserAgent(addPermissionRequest, USER_AGENT);
        return this.realSqs.addPermission(addPermissionRequest);
    }

    @Override
    public CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        ResultConverter.appendUserAgent(createQueueRequest, USER_AGENT);
        return this.realSqs.createQueue(createQueueRequest);
    }

    @Override
    public CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        ResultConverter.appendUserAgent(deleteQueueRequest, USER_AGENT);
        return this.realSqs.deleteQueue(deleteQueueRequest);
    }

    @Override
    public CompletableFuture<GetQueueAttributesResponse> getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        ResultConverter.appendUserAgent(getQueueAttributesRequest, USER_AGENT);
        return this.realSqs.getQueueAttributes(getQueueAttributesRequest);
    }

    @Override
    public CompletableFuture<GetQueueUrlResponse> getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        ResultConverter.appendUserAgent(getQueueUrlRequest, USER_AGENT);
        return this.realSqs.getQueueUrl(getQueueUrlRequest);
    }

    @Override
    public CompletableFuture<ListQueuesResponse> listQueues() {
        return this.listQueues((ListQueuesRequest)((Object)ListQueuesRequest.builder().build()));
    }

    @Override
    public CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        ResultConverter.appendUserAgent(listQueuesRequest, USER_AGENT);
        return this.realSqs.listQueues(listQueuesRequest);
    }

    @Override
    public CompletableFuture<PurgeQueueResponse> purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        ResultConverter.appendUserAgent(purgeQueueRequest, USER_AGENT);
        return this.realSqs.purgeQueue(purgeQueueRequest);
    }

    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        ResultConverter.appendUserAgent(removePermissionRequest, USER_AGENT);
        return this.realSqs.removePermission(removePermissionRequest);
    }

    @Override
    public CompletableFuture<SetQueueAttributesResponse> setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(setQueueAttributesRequest, USER_AGENT);
        return this.realSqs.setQueueAttributes(setQueueAttributesRequest);
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityBatchResponse> changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityBatchRequest, USER_AGENT);
        return this.realSqs.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(changeMessageVisibilityRequest.queueUrl());
        return CompletableFuture.completedFuture(buffer.changeMessageVisibilitySync(changeMessageVisibilityRequest));
    }

    @Override
    public CompletableFuture<SendMessageBatchResponse> sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(sendMessageBatchRequest, USER_AGENT);
        return this.realSqs.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest sendMessageRequest) throws AmazonClientException {
        QueueBuffer buffer = this.getQBuffer(sendMessageRequest.queueUrl());
        ResultConverter.appendUserAgent(sendMessageRequest, USER_AGENT);
        return CompletableFuture.completedFuture(buffer.sendMessageSync(sendMessageRequest));
    }

    @Override
    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(receiveMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(receiveMessageRequest.queueUrl());
        return CompletableFuture.completedFuture(buffer.receiveMessageSync(receiveMessageRequest));
    }

    @Override
    public CompletableFuture<DeleteMessageBatchResponse> deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageBatchRequest, USER_AGENT);
        return this.realSqs.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest deleteMessageRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(deleteMessageRequest.queueUrl());
        return CompletableFuture.completedFuture(buffer.deleteMessageSync(deleteMessageRequest));
    }

    @Override
    public CompletableFuture<ListDeadLetterSourceQueuesResponse> listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonClientException {
        ResultConverter.appendUserAgent(listDeadLetterSourceQueuesRequest, USER_AGENT);
        return this.realSqs.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    public void close() {
        this.realSqs.close();
    }

    private synchronized QueueBuffer getQBuffer(String qUrl) {
        QueueBuffer toReturn = (QueueBuffer)this.buffers.get(qUrl);
        if (null == toReturn) {
            QueueBufferConfig config = new QueueBufferConfig(this.bufferConfigExemplar);
            toReturn = new QueueBuffer(config, qUrl, this.realSqs);
            this.buffers.put(qUrl, toReturn);
        }
        return toReturn;
    }

    private class CachingMap
    extends LinkedHashMap<String, QueueBuffer> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_ENTRIES = 100;

        CachingMap(int initial, float loadFactor, boolean accessOrder) {
            super(initial, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, QueueBuffer> eldest) {
            return this.size() > 100;
        }
    }
}

