/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.util.StringUtils;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        List<String> actionsList;
        List<String> aWSAccountIdsList;
        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "SQSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)addPermissionRequest.queueUrl()));
        }
        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString((String)addPermissionRequest.label()));
        }
        if ((aWSAccountIdsList = addPermissionRequest.awsAccountIds()) != null) {
            if (!aWSAccountIdsList.isEmpty()) {
                int aWSAccountIdsListIndex = 1;
                for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                    if (aWSAccountIdsListValue != null) {
                        request.addParameter("AWSAccountId." + aWSAccountIdsListIndex, StringUtils.fromString((String)aWSAccountIdsListValue));
                    }
                    ++aWSAccountIdsListIndex;
                }
            } else {
                request.addParameter("AWSAccountId", "");
            }
        }
        if ((actionsList = addPermissionRequest.actions()) != null) {
            if (!actionsList.isEmpty()) {
                int actionsListIndex = 1;
                for (String actionsListValue : actionsList) {
                    if (actionsListValue != null) {
                        request.addParameter("ActionName." + actionsListIndex, StringUtils.fromString((String)actionsListValue));
                    }
                    ++actionsListIndex;
                }
            } else {
                request.addParameter("ActionName", "");
            }
        }
        return request;
    }
}

