/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.nio.ByteBuffer;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.util.StringUtils;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageRequest, "SQSClient");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)sendMessageRequest.queueUrl()));
        }
        if (sendMessageRequest.messageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString((String)sendMessageRequest.messageBody()));
        }
        if (sendMessageRequest.delaySeconds() != null) {
            request.addParameter("DelaySeconds", StringUtils.fromInteger((Integer)sendMessageRequest.delaySeconds()));
        }
        Map<String, MessageAttributeValue> messageAttributes = sendMessageRequest.messageAttributes();
        int messageAttributesListIndex = 1;
        for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                SdkInternalList binaryListValuesList;
                SdkInternalList stringListValuesList;
                if (entry.getValue().stringValue() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().stringValue()));
                }
                if (entry.getValue().binaryValue() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().binaryValue()));
                }
                if (!(stringListValuesList = (SdkInternalList)entry.getValue().stringListValues()).isEmpty() || !stringListValuesList.isAutoConstruct()) {
                    int stringListValuesListIndex = 1;
                    for (String stringListValuesListValue : stringListValuesList) {
                        if (stringListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString((String)stringListValuesListValue));
                        }
                        ++stringListValuesListIndex;
                    }
                }
                if (!(binaryListValuesList = (SdkInternalList)entry.getValue().binaryListValues()).isEmpty() || !binaryListValuesList.isAutoConstruct()) {
                    int binaryListValuesListIndex = 1;
                    for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                        if (binaryListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesListValue));
                        }
                        ++binaryListValuesListIndex;
                    }
                }
                if (entry.getValue().dataType() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().dataType()));
                }
            }
            ++messageAttributesListIndex;
        }
        if (sendMessageRequest.messageDeduplicationId() != null) {
            request.addParameter("MessageDeduplicationId", StringUtils.fromString((String)sendMessageRequest.messageDeduplicationId()));
        }
        if (sendMessageRequest.messageGroupId() != null) {
            request.addParameter("MessageGroupId", StringUtils.fromString((String)sendMessageRequest.messageGroupId()));
        }
        return request;
    }
}

