/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetQueueAttributesRequestMarshaller
implements Marshaller<Request<GetQueueAttributesRequest>, GetQueueAttributesRequest> {
    public Request<GetQueueAttributesRequest> marshall(GetQueueAttributesRequest getQueueAttributesRequest) {
        SdkInternalList attributeNamesList;
        if (getQueueAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getQueueAttributesRequest, "SQSClient");
        request.addParameter("Action", "GetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (getQueueAttributesRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)getQueueAttributesRequest.queueUrl()));
        }
        if (!(attributeNamesList = (SdkInternalList)getQueueAttributesRequest.attributeNames()).isEmpty() || !attributeNamesList.isAutoConstruct()) {
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

