/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendMessageRequest> {
    private final String queueUrl;
    private final String messageBody;
    private final Integer delaySeconds;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private SendMessageRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.messageBody = builder.messageBody;
        this.delaySeconds = builder.delaySeconds;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String messageBody() {
        return this.messageBody;
    }

    public Integer delaySeconds() {
        return this.delaySeconds;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public String messageGroupId() {
        return this.messageGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.messageBody() == null ? 0 : this.messageBody().hashCode());
        hashCode = 31 * hashCode + (this.delaySeconds() == null ? 0 : this.delaySeconds().hashCode());
        hashCode = 31 * hashCode + (this.messageAttributes() == null ? 0 : this.messageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.messageDeduplicationId() == null ? 0 : this.messageDeduplicationId().hashCode());
        hashCode = 31 * hashCode + (this.messageGroupId() == null ? 0 : this.messageGroupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.messageBody() == null ^ this.messageBody() == null) {
            return false;
        }
        if (other.messageBody() != null && !other.messageBody().equals(this.messageBody())) {
            return false;
        }
        if (other.delaySeconds() == null ^ this.delaySeconds() == null) {
            return false;
        }
        if (other.delaySeconds() != null && !other.delaySeconds().equals(this.delaySeconds())) {
            return false;
        }
        if (other.messageAttributes() == null ^ this.messageAttributes() == null) {
            return false;
        }
        if (other.messageAttributes() != null && !other.messageAttributes().equals(this.messageAttributes())) {
            return false;
        }
        if (other.messageDeduplicationId() == null ^ this.messageDeduplicationId() == null) {
            return false;
        }
        if (other.messageDeduplicationId() != null && !other.messageDeduplicationId().equals(this.messageDeduplicationId())) {
            return false;
        }
        if (other.messageGroupId() == null ^ this.messageGroupId() == null) {
            return false;
        }
        return other.messageGroupId() == null || other.messageGroupId().equals(this.messageGroupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.messageBody() != null) {
            sb.append("MessageBody: ").append(this.messageBody()).append(",");
        }
        if (this.delaySeconds() != null) {
            sb.append("DelaySeconds: ").append(this.delaySeconds()).append(",");
        }
        if (this.messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.messageAttributes()).append(",");
        }
        if (this.messageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: ").append(this.messageDeduplicationId()).append(",");
        }
        if (this.messageGroupId() != null) {
            sb.append("MessageGroupId: ").append(this.messageGroupId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private String messageBody;
        private Integer delaySeconds;
        private Map<String, MessageAttributeValue> messageAttributes = new SdkInternalMap();
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setMessageBody(model.messageBody);
            this.setDelaySeconds(model.delaySeconds);
            this.setMessageAttributes(model.messageAttributes);
            this.setMessageDeduplicationId(model.messageDeduplicationId);
            this.setMessageGroupId(model.messageGroupId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final Integer getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public final Builder delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public final void setDelaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
        }

        public final Map<String, MessageAttributeValue> getMessageAttributes() {
            return this.messageAttributes;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder messageBody(String var1);

        public Builder delaySeconds(Integer var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);
    }
}

