/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetQueueUrlRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetQueueUrlRequest> {
    private final String queueName;
    private final String queueOwnerAWSAccountId;

    private GetQueueUrlRequest(BuilderImpl builder) {
        this.queueName = builder.queueName;
        this.queueOwnerAWSAccountId = builder.queueOwnerAWSAccountId;
    }

    public String queueName() {
        return this.queueName;
    }

    public String queueOwnerAWSAccountId() {
        return this.queueOwnerAWSAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueName() == null ? 0 : this.queueName().hashCode());
        hashCode = 31 * hashCode + (this.queueOwnerAWSAccountId() == null ? 0 : this.queueOwnerAWSAccountId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueUrlRequest)) {
            return false;
        }
        GetQueueUrlRequest other = (GetQueueUrlRequest)((Object)obj);
        if (other.queueName() == null ^ this.queueName() == null) {
            return false;
        }
        if (other.queueName() != null && !other.queueName().equals(this.queueName())) {
            return false;
        }
        if (other.queueOwnerAWSAccountId() == null ^ this.queueOwnerAWSAccountId() == null) {
            return false;
        }
        return other.queueOwnerAWSAccountId() == null || other.queueOwnerAWSAccountId().equals(this.queueOwnerAWSAccountId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueName() != null) {
            sb.append("QueueName: ").append(this.queueName()).append(",");
        }
        if (this.queueOwnerAWSAccountId() != null) {
            sb.append("QueueOwnerAWSAccountId: ").append(this.queueOwnerAWSAccountId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueName;
        private String queueOwnerAWSAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueUrlRequest model) {
            this.setQueueName(model.queueName);
            this.setQueueOwnerAWSAccountId(model.queueOwnerAWSAccountId);
        }

        public final String getQueueName() {
            return this.queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final String getQueueOwnerAWSAccountId() {
            return this.queueOwnerAWSAccountId;
        }

        @Override
        public final Builder queueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
            return this;
        }

        public final void setQueueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
        }

        public GetQueueUrlRequest build() {
            return new GetQueueUrlRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetQueueUrlRequest> {
        public Builder queueName(String var1);

        public Builder queueOwnerAWSAccountId(String var1);
    }
}

