/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.buffered;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.handlers.AsyncHandler;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferCallback;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferConfig;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferFuture;
import software.amazon.awssdk.services.sqs.buffered.ReceiveQueueBuffer;
import software.amazon.awssdk.services.sqs.buffered.SendQueueBuffer;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

class QueueBuffer {
    static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());
    QueueBufferConfig config;
    private final SendQueueBuffer sendBuffer;
    private final ReceiveQueueBuffer receiveBuffer;
    private final SQSAsyncClient realSqs;

    QueueBuffer(QueueBufferConfig paramConfig, String url, SQSAsyncClient sqs) {
        this.realSqs = sqs;
        this.config = paramConfig;
        this.sendBuffer = new SendQueueBuffer(sqs, executor, paramConfig, url);
        this.receiveBuffer = new ReceiveQueueBuffer(sqs, executor, paramConfig, url);
    }

    public Future<SendMessageResponse> sendMessage(SendMessageRequest request, AsyncHandler<SendMessageRequest, SendMessageResponse> handler) {
        QueueBufferCallback<SendMessageRequest, SendMessageResponse> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<SendMessageRequest, SendMessageResponse>(handler, request);
        }
        QueueBufferFuture<SendMessageRequest, SendMessageResponse> future = this.sendBuffer.sendMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public SendMessageResponse sendMessageSync(SendMessageRequest request) {
        Future<SendMessageResponse> future = this.sendMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request, AsyncHandler<DeleteMessageRequest, DeleteMessageResponse> handler) {
        QueueBufferCallback<DeleteMessageRequest, DeleteMessageResponse> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<DeleteMessageRequest, DeleteMessageResponse>(handler, request);
        }
        QueueBufferFuture<DeleteMessageRequest, DeleteMessageResponse> future = this.sendBuffer.deleteMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public DeleteMessageResponse deleteMessageSync(DeleteMessageRequest request) {
        Future<DeleteMessageResponse> future = this.deleteMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest request, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> handler) {
        QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse>(handler, request);
        }
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> future = this.sendBuffer.changeMessageVisibility(request, callback);
        future.setBuffer(this);
        return future;
    }

    public ChangeMessageVisibilityResponse changeMessageVisibilitySync(ChangeMessageVisibilityRequest request) {
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> future = this.sendBuffer.changeMessageVisibility(request, null);
        return (ChangeMessageVisibilityResponse)((Object)this.waitForFuture(future));
    }

    public Future<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest rq, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResponse> handler) {
        if (this.canBeRetrievedFromQueueBuffer(rq)) {
            QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResponse> callback = null;
            if (handler != null) {
                callback = new QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResponse>(handler, rq);
            }
            QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResponse> future = this.receiveBuffer.receiveMessageAsync(rq, callback);
            future.setBuffer(this);
            return future;
        }
        if (handler != null) {
            return this.realSqs.receiveMessage(rq);
        }
        return this.realSqs.receiveMessage(rq);
    }

    public ReceiveMessageResponse receiveMessageSync(ReceiveMessageRequest rq) {
        Future<ReceiveMessageResponse> future = this.receiveMessage(rq, null);
        return this.waitForFuture(future);
    }

    public void shutdown() {
        if (this.config.isFlushOnShutdown()) {
            this.flush();
        }
        this.receiveBuffer.shutdown();
    }

    void flush() {
        this.sendBuffer.flush();
    }

    private boolean canBeRetrievedFromQueueBuffer(ReceiveMessageRequest rq) {
        return !this.hasRequestedQueueAttributes(rq) && !this.hasRequestedMessageAttributes(rq) && this.isBufferingEnabled() && rq.visibilityTimeout() == null;
    }

    private boolean hasRequestedQueueAttributes(ReceiveMessageRequest rq) {
        return rq.attributeNames() != null && !rq.attributeNames().isEmpty();
    }

    private boolean hasRequestedMessageAttributes(ReceiveMessageRequest rq) {
        return rq.messageAttributeNames() != null && !rq.messageAttributeNames().isEmpty();
    }

    private boolean isBufferingEnabled() {
        return this.config.getMaxInflightReceiveBatches() > 0 && this.config.getMaxDoneReceiveBatches() > 0;
    }

    private <ResultTypeT> ResultTypeT waitForFuture(Future<ResultTypeT> future) {
        ResultTypeT toReturn = null;
        try {
            toReturn = future.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            AmazonClientException ce = new AmazonClientException("Thread interrupted while waiting for execution result");
            ce.initCause((Throwable)ie);
            throw ce;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof AmazonClientException) {
                throw (AmazonClientException)cause;
            }
            AmazonClientException ce = new AmazonClientException("Caught an exception while waiting for request to complete...");
            ce.initCause((Throwable)ee);
            throw ce;
        }
        return toReturn;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static AtomicInteger threadCount = new AtomicInteger(0);

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = threadCount.addAndGet(1);
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("SQSQueueBufferWorkerThread-" + threadNumber);
            return thread;
        }
    }
}

