/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.RegistrationStatus;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkedWhatsAppBusinessAccountSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkedWhatsAppBusinessAccountSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::arn)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::id)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> WABA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wabaId").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::wabaId)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::wabaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wabaId").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationStatus").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::registrationStatusAsString)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<Instant> LINK_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("linkDate").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::linkDate)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::linkDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkDate").build()}).build();
    private static final SdkField<String> WABA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wabaName").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::wabaName)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::wabaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wabaName").build()}).build();
    private static final SdkField<List<WhatsAppBusinessAccountEventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventDestinations").getter(LinkedWhatsAppBusinessAccountSummary.getter(LinkedWhatsAppBusinessAccountSummary::eventDestinations)).setter(LinkedWhatsAppBusinessAccountSummary.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatsAppBusinessAccountEventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, WABA_ID_FIELD, REGISTRATION_STATUS_FIELD, LINK_DATE_FIELD, WABA_NAME_FIELD, EVENT_DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LinkedWhatsAppBusinessAccountSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String wabaId;
    private final String registrationStatus;
    private final Instant linkDate;
    private final String wabaName;
    private final List<WhatsAppBusinessAccountEventDestination> eventDestinations;

    private LinkedWhatsAppBusinessAccountSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.wabaId = builder.wabaId;
        this.registrationStatus = builder.registrationStatus;
        this.linkDate = builder.linkDate;
        this.wabaName = builder.wabaName;
        this.eventDestinations = builder.eventDestinations;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String wabaId() {
        return this.wabaId;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final Instant linkDate() {
        return this.linkDate;
    }

    public final String wabaName() {
        return this.wabaName;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<WhatsAppBusinessAccountEventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.wabaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.wabaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedWhatsAppBusinessAccountSummary)) {
            return false;
        }
        LinkedWhatsAppBusinessAccountSummary other = (LinkedWhatsAppBusinessAccountSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.wabaId(), other.wabaId()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && Objects.equals(this.linkDate(), other.linkDate()) && Objects.equals(this.wabaName(), other.wabaName()) && this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"LinkedWhatsAppBusinessAccountSummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("WabaId", (Object)this.wabaId()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("LinkDate", (Object)this.linkDate()).add("WabaName", (Object)this.wabaName()).add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "wabaId": {
                return Optional.ofNullable(clazz.cast(this.wabaId()));
            }
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "linkDate": {
                return Optional.ofNullable(clazz.cast(this.linkDate()));
            }
            case "wabaName": {
                return Optional.ofNullable(clazz.cast(this.wabaName()));
            }
            case "eventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("wabaId", WABA_ID_FIELD);
        map.put("registrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("linkDate", LINK_DATE_FIELD);
        map.put("wabaName", WABA_NAME_FIELD);
        map.put("eventDestinations", EVENT_DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkedWhatsAppBusinessAccountSummary, T> g) {
        return obj -> g.apply((LinkedWhatsAppBusinessAccountSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String wabaId;
        private String registrationStatus;
        private Instant linkDate;
        private String wabaName;
        private List<WhatsAppBusinessAccountEventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedWhatsAppBusinessAccountSummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.wabaId(model.wabaId);
            this.registrationStatus(model.registrationStatus);
            this.linkDate(model.linkDate);
            this.wabaName(model.wabaName);
            this.eventDestinations(model.eventDestinations);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getWabaId() {
            return this.wabaId;
        }

        public final void setWabaId(String wabaId) {
            this.wabaId = wabaId;
        }

        @Override
        public final Builder wabaId(String wabaId) {
            this.wabaId = wabaId;
            return this;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final Instant getLinkDate() {
            return this.linkDate;
        }

        public final void setLinkDate(Instant linkDate) {
            this.linkDate = linkDate;
        }

        @Override
        public final Builder linkDate(Instant linkDate) {
            this.linkDate = linkDate;
            return this;
        }

        public final String getWabaName() {
            return this.wabaName;
        }

        public final void setWabaName(String wabaName) {
            this.wabaName = wabaName;
        }

        @Override
        public final Builder wabaName(String wabaName) {
            this.wabaName = wabaName;
            return this;
        }

        public final List<WhatsAppBusinessAccountEventDestination.Builder> getEventDestinations() {
            List<WhatsAppBusinessAccountEventDestination.Builder> result = WhatsAppBusinessAccountEventDestinationsCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<WhatsAppBusinessAccountEventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (WhatsAppBusinessAccountEventDestination)((WhatsAppBusinessAccountEventDestination.Builder)WhatsAppBusinessAccountEventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LinkedWhatsAppBusinessAccountSummary build() {
            return new LinkedWhatsAppBusinessAccountSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkedWhatsAppBusinessAccountSummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder wabaId(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder linkDate(Instant var1);

        public Builder wabaName(String var1);

        public Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> var1);

        public Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... var1);

        public Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... var1);
    }
}

