/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingRequest;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutWhatsAppBusinessAccountEventDestinationsRequest
extends SocialMessagingRequest
implements ToCopyableBuilder<Builder, PutWhatsAppBusinessAccountEventDestinationsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PutWhatsAppBusinessAccountEventDestinationsRequest.getter(PutWhatsAppBusinessAccountEventDestinationsRequest::id)).setter(PutWhatsAppBusinessAccountEventDestinationsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<WhatsAppBusinessAccountEventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventDestinations").getter(PutWhatsAppBusinessAccountEventDestinationsRequest.getter(PutWhatsAppBusinessAccountEventDestinationsRequest::eventDestinations)).setter(PutWhatsAppBusinessAccountEventDestinationsRequest.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatsAppBusinessAccountEventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENT_DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutWhatsAppBusinessAccountEventDestinationsRequest.memberNameToFieldInitializer();
    private final String id;
    private final List<WhatsAppBusinessAccountEventDestination> eventDestinations;

    private PutWhatsAppBusinessAccountEventDestinationsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.eventDestinations = builder.eventDestinations;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<WhatsAppBusinessAccountEventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutWhatsAppBusinessAccountEventDestinationsRequest)) {
            return false;
        }
        PutWhatsAppBusinessAccountEventDestinationsRequest other = (PutWhatsAppBusinessAccountEventDestinationsRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"PutWhatsAppBusinessAccountEventDestinationsRequest").add("Id", (Object)this.id()).add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "eventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("eventDestinations", EVENT_DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutWhatsAppBusinessAccountEventDestinationsRequest, T> g) {
        return obj -> g.apply((PutWhatsAppBusinessAccountEventDestinationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingRequest.BuilderImpl
    implements Builder {
        private String id;
        private List<WhatsAppBusinessAccountEventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutWhatsAppBusinessAccountEventDestinationsRequest model) {
            super(model);
            this.id(model.id);
            this.eventDestinations(model.eventDestinations);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<WhatsAppBusinessAccountEventDestination.Builder> getEventDestinations() {
            List<WhatsAppBusinessAccountEventDestination.Builder> result = WhatsAppBusinessAccountEventDestinationsCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<WhatsAppBusinessAccountEventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (WhatsAppBusinessAccountEventDestination)((WhatsAppBusinessAccountEventDestination.Builder)WhatsAppBusinessAccountEventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutWhatsAppBusinessAccountEventDestinationsRequest build() {
            return new PutWhatsAppBusinessAccountEventDestinationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SocialMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutWhatsAppBusinessAccountEventDestinationsRequest> {
        public Builder id(String var1);

        public Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> var1);

        public Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... var1);

        public Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

