/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary;
import software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummaryListCopier;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLinkedWhatsAppBusinessAccountsResponse
extends SocialMessagingResponse
implements ToCopyableBuilder<Builder, ListLinkedWhatsAppBusinessAccountsResponse> {
    private static final SdkField<List<LinkedWhatsAppBusinessAccountSummary>> LINKED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("linkedAccounts").getter(ListLinkedWhatsAppBusinessAccountsResponse.getter(ListLinkedWhatsAppBusinessAccountsResponse::linkedAccounts)).setter(ListLinkedWhatsAppBusinessAccountsResponse.setter(Builder::linkedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LinkedWhatsAppBusinessAccountSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLinkedWhatsAppBusinessAccountsResponse.getter(ListLinkedWhatsAppBusinessAccountsResponse::nextToken)).setter(ListLinkedWhatsAppBusinessAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLinkedWhatsAppBusinessAccountsResponse.memberNameToFieldInitializer();
    private final List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts;
    private final String nextToken;

    private ListLinkedWhatsAppBusinessAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.linkedAccounts = builder.linkedAccounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLinkedAccounts() {
        return this.linkedAccounts != null && !(this.linkedAccounts instanceof SdkAutoConstructList);
    }

    public final List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts() {
        return this.linkedAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedAccounts() ? this.linkedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLinkedWhatsAppBusinessAccountsResponse)) {
            return false;
        }
        ListLinkedWhatsAppBusinessAccountsResponse other = (ListLinkedWhatsAppBusinessAccountsResponse)((Object)obj);
        return this.hasLinkedAccounts() == other.hasLinkedAccounts() && Objects.equals(this.linkedAccounts(), other.linkedAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLinkedWhatsAppBusinessAccountsResponse").add("LinkedAccounts", this.hasLinkedAccounts() ? this.linkedAccounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "linkedAccounts": {
                return Optional.ofNullable(clazz.cast(this.linkedAccounts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkedAccounts", LINKED_ACCOUNTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLinkedWhatsAppBusinessAccountsResponse, T> g) {
        return obj -> g.apply((ListLinkedWhatsAppBusinessAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingResponse.BuilderImpl
    implements Builder {
        private List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLinkedWhatsAppBusinessAccountsResponse model) {
            super(model);
            this.linkedAccounts(model.linkedAccounts);
            this.nextToken(model.nextToken);
        }

        public final List<LinkedWhatsAppBusinessAccountSummary.Builder> getLinkedAccounts() {
            List<LinkedWhatsAppBusinessAccountSummary.Builder> result = LinkedWhatsAppBusinessAccountSummaryListCopier.copyToBuilder(this.linkedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary.BuilderImpl> linkedAccounts) {
            this.linkedAccounts = LinkedWhatsAppBusinessAccountSummaryListCopier.copyFromBuilder(linkedAccounts);
        }

        @Override
        public final Builder linkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary> linkedAccounts) {
            this.linkedAccounts = LinkedWhatsAppBusinessAccountSummaryListCopier.copy(linkedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(LinkedWhatsAppBusinessAccountSummary ... linkedAccounts) {
            this.linkedAccounts(Arrays.asList(linkedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(Consumer<LinkedWhatsAppBusinessAccountSummary.Builder> ... linkedAccounts) {
            this.linkedAccounts(Stream.of(linkedAccounts).map(c -> (LinkedWhatsAppBusinessAccountSummary)((LinkedWhatsAppBusinessAccountSummary.Builder)LinkedWhatsAppBusinessAccountSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLinkedWhatsAppBusinessAccountsResponse build() {
            return new ListLinkedWhatsAppBusinessAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SocialMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLinkedWhatsAppBusinessAccountsResponse> {
        public Builder linkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary> var1);

        public Builder linkedAccounts(LinkedWhatsAppBusinessAccountSummary ... var1);

        public Builder linkedAccounts(Consumer<LinkedWhatsAppBusinessAccountSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

