/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingClient;
import software.amazon.awssdk.services.socialmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;

public class ListLinkedWhatsAppBusinessAccountsIterable
implements SdkIterable<ListLinkedWhatsAppBusinessAccountsResponse> {
    private final SocialMessagingClient client;
    private final ListLinkedWhatsAppBusinessAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLinkedWhatsAppBusinessAccountsIterable(SocialMessagingClient client, ListLinkedWhatsAppBusinessAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLinkedWhatsAppBusinessAccountsResponseFetcher();
    }

    public Iterator<ListLinkedWhatsAppBusinessAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LinkedWhatsAppBusinessAccountSummary> linkedAccounts() {
        Function<ListLinkedWhatsAppBusinessAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.linkedAccounts() != null) {
                return response.linkedAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLinkedWhatsAppBusinessAccountsResponseFetcher
    implements SyncPageFetcher<ListLinkedWhatsAppBusinessAccountsResponse> {
        private ListLinkedWhatsAppBusinessAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListLinkedWhatsAppBusinessAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLinkedWhatsAppBusinessAccountsResponse nextPage(ListLinkedWhatsAppBusinessAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListLinkedWhatsAppBusinessAccountsIterable.this.client.listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsIterable.this.firstRequest);
            }
            return ListLinkedWhatsAppBusinessAccountsIterable.this.client.listLinkedWhatsAppBusinessAccounts((ListLinkedWhatsAppBusinessAccountsRequest)((Object)ListLinkedWhatsAppBusinessAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

