/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.Tag;
import software.amazon.awssdk.services.socialmessaging.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WabaPhoneNumberSetupFinalization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WabaPhoneNumberSetupFinalization> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WabaPhoneNumberSetupFinalization.getter(WabaPhoneNumberSetupFinalization::id)).setter(WabaPhoneNumberSetupFinalization.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TWO_FACTOR_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("twoFactorPin").getter(WabaPhoneNumberSetupFinalization.getter(WabaPhoneNumberSetupFinalization::twoFactorPin)).setter(WabaPhoneNumberSetupFinalization.setter(Builder::twoFactorPin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("twoFactorPin").build()}).build();
    private static final SdkField<String> DATA_LOCALIZATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLocalizationRegion").getter(WabaPhoneNumberSetupFinalization.getter(WabaPhoneNumberSetupFinalization::dataLocalizationRegion)).setter(WabaPhoneNumberSetupFinalization.setter(Builder::dataLocalizationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocalizationRegion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(WabaPhoneNumberSetupFinalization.getter(WabaPhoneNumberSetupFinalization::tags)).setter(WabaPhoneNumberSetupFinalization.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TWO_FACTOR_PIN_FIELD, DATA_LOCALIZATION_REGION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String twoFactorPin;
    private final String dataLocalizationRegion;
    private final List<Tag> tags;

    private WabaPhoneNumberSetupFinalization(BuilderImpl builder) {
        this.id = builder.id;
        this.twoFactorPin = builder.twoFactorPin;
        this.dataLocalizationRegion = builder.dataLocalizationRegion;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String twoFactorPin() {
        return this.twoFactorPin;
    }

    public final String dataLocalizationRegion() {
        return this.dataLocalizationRegion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoFactorPin());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocalizationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WabaPhoneNumberSetupFinalization)) {
            return false;
        }
        WabaPhoneNumberSetupFinalization other = (WabaPhoneNumberSetupFinalization)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.twoFactorPin(), other.twoFactorPin()) && Objects.equals(this.dataLocalizationRegion(), other.dataLocalizationRegion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"WabaPhoneNumberSetupFinalization").add("Id", (Object)this.id()).add("TwoFactorPin", (Object)(this.twoFactorPin() == null ? null : "*** Sensitive Data Redacted ***")).add("DataLocalizationRegion", (Object)this.dataLocalizationRegion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "twoFactorPin": {
                return Optional.ofNullable(clazz.cast(this.twoFactorPin()));
            }
            case "dataLocalizationRegion": {
                return Optional.ofNullable(clazz.cast(this.dataLocalizationRegion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WabaPhoneNumberSetupFinalization, T> g) {
        return obj -> g.apply((WabaPhoneNumberSetupFinalization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String twoFactorPin;
        private String dataLocalizationRegion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WabaPhoneNumberSetupFinalization model) {
            this.id(model.id);
            this.twoFactorPin(model.twoFactorPin);
            this.dataLocalizationRegion(model.dataLocalizationRegion);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTwoFactorPin() {
            return this.twoFactorPin;
        }

        public final void setTwoFactorPin(String twoFactorPin) {
            this.twoFactorPin = twoFactorPin;
        }

        @Override
        public final Builder twoFactorPin(String twoFactorPin) {
            this.twoFactorPin = twoFactorPin;
            return this;
        }

        public final String getDataLocalizationRegion() {
            return this.dataLocalizationRegion;
        }

        public final void setDataLocalizationRegion(String dataLocalizationRegion) {
            this.dataLocalizationRegion = dataLocalizationRegion;
        }

        @Override
        public final Builder dataLocalizationRegion(String dataLocalizationRegion) {
            this.dataLocalizationRegion = dataLocalizationRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WabaPhoneNumberSetupFinalization build() {
            return new WabaPhoneNumberSetupFinalization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WabaPhoneNumberSetupFinalization> {
        public Builder id(String var1);

        public Builder twoFactorPin(String var1);

        public Builder dataLocalizationRegion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

