/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsIterable
implements SdkIterable<ListSubscriptionsResponse> {
    private final SnsClient client;
    private final ListSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionsIterable(SnsClient client, ListSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsResponseFetcher();
    }

    public Iterator<ListSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListSubscriptionsIterable resume(ListSubscriptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSubscriptionsIterable(this.client, (ListSubscriptionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSubscriptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSubscriptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionsResponse> {
        private ListSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscriptionsResponse nextPage(ListSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsIterable.this.client.listSubscriptions(ListSubscriptionsIterable.this.firstRequest);
            }
            return ListSubscriptionsIterable.this.client.listSubscriptions((ListSubscriptionsRequest)((Object)ListSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

