/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse;
import software.amazon.awssdk.services.sns.model.PhoneNumberInformation;

public class ListOriginationNumbersIterable
implements SdkIterable<ListOriginationNumbersResponse> {
    private final SnsClient client;
    private final ListOriginationNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOriginationNumbersIterable(SnsClient client, ListOriginationNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOriginationNumbersResponseFetcher();
    }

    public Iterator<ListOriginationNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PhoneNumberInformation> phoneNumbers() {
        Function<ListOriginationNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOriginationNumbersResponseFetcher
    implements SyncPageFetcher<ListOriginationNumbersResponse> {
        private ListOriginationNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginationNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOriginationNumbersResponse nextPage(ListOriginationNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListOriginationNumbersIterable.this.client.listOriginationNumbers(ListOriginationNumbersIterable.this.firstRequest);
            }
            return ListOriginationNumbersIterable.this.client.listOriginationNumbers((ListOriginationNumbersRequest)((Object)ListOriginationNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

