/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.NumberCapability;
import software.amazon.awssdk.services.sns.model.NumberCapabilityListCopier;
import software.amazon.awssdk.services.sns.model.RouteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberInformation> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(PhoneNumberInformation.getter(PhoneNumberInformation::createdAt)).setter(PhoneNumberInformation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(PhoneNumberInformation.getter(PhoneNumberInformation::phoneNumber)).setter(PhoneNumberInformation.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PhoneNumberInformation.getter(PhoneNumberInformation::status)).setter(PhoneNumberInformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ISO2_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Iso2CountryCode").getter(PhoneNumberInformation.getter(PhoneNumberInformation::iso2CountryCode)).setter(PhoneNumberInformation.setter(Builder::iso2CountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iso2CountryCode").build()}).build();
    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteType").getter(PhoneNumberInformation.getter(PhoneNumberInformation::routeTypeAsString)).setter(PhoneNumberInformation.setter(Builder::routeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()}).build();
    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberCapabilities").getter(PhoneNumberInformation.getter(PhoneNumberInformation::numberCapabilitiesAsStrings)).setter(PhoneNumberInformation.setter(Builder::numberCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, PHONE_NUMBER_FIELD, STATUS_FIELD, ISO2_COUNTRY_CODE_FIELD, ROUTE_TYPE_FIELD, NUMBER_CAPABILITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String phoneNumber;
    private final String status;
    private final String iso2CountryCode;
    private final String routeType;
    private final List<String> numberCapabilities;

    private PhoneNumberInformation(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
        this.iso2CountryCode = builder.iso2CountryCode;
        this.routeType = builder.routeType;
        this.numberCapabilities = builder.numberCapabilities;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String status() {
        return this.status;
    }

    public final String iso2CountryCode() {
        return this.iso2CountryCode;
    }

    public final RouteType routeType() {
        return RouteType.fromValue(this.routeType);
    }

    public final String routeTypeAsString() {
        return this.routeType;
    }

    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(this.numberCapabilities);
    }

    public final boolean hasNumberCapabilities() {
        return this.numberCapabilities != null && !(this.numberCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> numberCapabilitiesAsStrings() {
        return this.numberCapabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.iso2CountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberInformation)) {
            return false;
        }
        PhoneNumberInformation other = (PhoneNumberInformation)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.iso2CountryCode(), other.iso2CountryCode()) && Objects.equals(this.routeTypeAsString(), other.routeTypeAsString()) && this.hasNumberCapabilities() == other.hasNumberCapabilities() && Objects.equals(this.numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberInformation").add("CreatedAt", (Object)this.createdAt()).add("PhoneNumber", (Object)this.phoneNumber()).add("Status", (Object)this.status()).add("Iso2CountryCode", (Object)this.iso2CountryCode()).add("RouteType", (Object)this.routeTypeAsString()).add("NumberCapabilities", this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Iso2CountryCode": {
                return Optional.ofNullable(clazz.cast(this.iso2CountryCode()));
            }
            case "RouteType": {
                return Optional.ofNullable(clazz.cast(this.routeTypeAsString()));
            }
            case "NumberCapabilities": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberInformation, T> g) {
        return obj -> g.apply((PhoneNumberInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String phoneNumber;
        private String status;
        private String iso2CountryCode;
        private String routeType;
        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberInformation model) {
            this.createdAt(model.createdAt);
            this.phoneNumber(model.phoneNumber);
            this.status(model.status);
            this.iso2CountryCode(model.iso2CountryCode);
            this.routeType(model.routeType);
            this.numberCapabilitiesWithStrings(model.numberCapabilities);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        @Transient
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getIso2CountryCode() {
            return this.iso2CountryCode;
        }

        public final void setIso2CountryCode(String iso2CountryCode) {
            this.iso2CountryCode = iso2CountryCode;
        }

        @Override
        @Transient
        public final Builder iso2CountryCode(String iso2CountryCode) {
            this.iso2CountryCode = iso2CountryCode;
            return this;
        }

        public final String getRouteType() {
            return this.routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        @Transient
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        @Transient
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (this.numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        @Transient
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String ... numberCapabilities) {
            this.numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        @Transient
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability ... numberCapabilities) {
            this.numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public PhoneNumberInformation build() {
            return new PhoneNumberInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberInformation> {
        public Builder createdAt(Instant var1);

        public Builder phoneNumber(String var1);

        public Builder status(String var1);

        public Builder iso2CountryCode(String var1);

        public Builder routeType(String var1);

        public Builder routeType(RouteType var1);

        public Builder numberCapabilitiesWithStrings(Collection<String> var1);

        public Builder numberCapabilitiesWithStrings(String ... var1);

        public Builder numberCapabilities(Collection<NumberCapability> var1);

        public Builder numberCapabilities(NumberCapability ... var1);
    }
}

