/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse;
import software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber;

public class ListSMSSandboxPhoneNumbersPublisher
implements SdkPublisher<ListSmsSandboxPhoneNumbersResponse> {
    private final SnsAsyncClient client;
    private final ListSmsSandboxPhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSMSSandboxPhoneNumbersPublisher(SnsAsyncClient client, ListSmsSandboxPhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSMSSandboxPhoneNumbersPublisher(SnsAsyncClient client, ListSmsSandboxPhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSmsSandboxPhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSmsSandboxPhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SMSSandboxPhoneNumber> phoneNumbers() {
        Function<ListSmsSandboxPhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSmsSandboxPhoneNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSmsSandboxPhoneNumbersResponseFetcher
    implements AsyncPageFetcher<ListSmsSandboxPhoneNumbersResponse> {
        private ListSmsSandboxPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListSmsSandboxPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSmsSandboxPhoneNumbersResponse> nextPage(ListSmsSandboxPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListSMSSandboxPhoneNumbersPublisher.this.client.listSMSSandboxPhoneNumbers(ListSMSSandboxPhoneNumbersPublisher.this.firstRequest);
            }
            return ListSMSSandboxPhoneNumbersPublisher.this.client.listSMSSandboxPhoneNumbers((ListSmsSandboxPhoneNumbersRequest)((Object)ListSMSSandboxPhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

