/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListEndpointsByPlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEndpointsByPlatformApplicationResponse extends SnsResponse implements
        ToCopyableBuilder<ListEndpointsByPlatformApplicationResponse.Builder, ListEndpointsByPlatformApplicationResponse> {
    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField
            .<List<Endpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(ListEndpointsByPlatformApplicationResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Endpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEndpointsByPlatformApplicationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Endpoint> endpoints;

    private final String nextToken;

    private ListEndpointsByPlatformApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Endpoints returned for ListEndpointsByPlatformApplication action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Endpoints returned for ListEndpointsByPlatformApplication action.
     */
    public final List<Endpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records are
     * available after the first page results.
     * </p>
     * 
     * @return NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records
     *         are available after the first page results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsByPlatformApplicationResponse)) {
            return false;
        }
        ListEndpointsByPlatformApplicationResponse other = (ListEndpointsByPlatformApplicationResponse) obj;
        return hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEndpointsByPlatformApplicationResponse")
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsByPlatformApplicationResponse, T> g) {
        return obj -> g.apply((ListEndpointsByPlatformApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
        /**
         * <p>
         * Endpoints returned for ListEndpointsByPlatformApplication action.
         * </p>
         * 
         * @param endpoints
         *        Endpoints returned for ListEndpointsByPlatformApplication action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<Endpoint> endpoints);

        /**
         * <p>
         * Endpoints returned for ListEndpointsByPlatformApplication action.
         * </p>
         * 
         * @param endpoints
         *        Endpoints returned for ListEndpointsByPlatformApplication action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Endpoint... endpoints);

        /**
         * <p>
         * Endpoints returned for ListEndpointsByPlatformApplication action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Endpoint>.Builder} avoiding the need to
         * create one manually via {@link List<Endpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Endpoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoints(List<Endpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<Endpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<Endpoint>)
         */
        Builder endpoints(Consumer<Endpoint.Builder>... endpoints);

        /**
         * <p>
         * NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records are
         * available after the first page results.
         * </p>
         * 
         * @param nextToken
         *        NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional
         *        records are available after the first page results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsByPlatformApplicationResponse model) {
            super(model);
            endpoints(model.endpoints);
            nextToken(model.nextToken);
        }

        public final Collection<Endpoint.Builder> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endpoints != null ? endpoints.stream().map(Endpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> Endpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsByPlatformApplicationResponse build() {
            return new ListEndpointsByPlatformApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
