/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageAttributeValue> {
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(MessageAttributeValue.getter(MessageAttributeValue::dataType)).setter(MessageAttributeValue.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(MessageAttributeValue.getter(MessageAttributeValue::stringValue)).setter(MessageAttributeValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final SdkField<SdkBytes> BINARY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("BinaryValue").getter(MessageAttributeValue.getter(MessageAttributeValue::binaryValue)).setter(MessageAttributeValue.setter(Builder::binaryValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD, STRING_VALUE_FIELD, BINARY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataType;
    private final String stringValue;
    private final SdkBytes binaryValue;

    private MessageAttributeValue(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
    }

    public final String dataType() {
        return this.dataType;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final SdkBytes binaryValue() {
        return this.binaryValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        return Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.binaryValue(), other.binaryValue());
    }

    public final String toString() {
        return ToString.builder((String)"MessageAttributeValue").add("DataType", (Object)this.dataType()).add("StringValue", (Object)this.stringValue()).add("BinaryValue", (Object)this.binaryValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "BinaryValue": {
                return Optional.ofNullable(clazz.cast(this.binaryValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageAttributeValue, T> g) {
        return obj -> g.apply((MessageAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataType;
        private String stringValue;
        private SdkBytes binaryValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageAttributeValue model) {
            this.dataType(model.dataType);
            this.stringValue(model.stringValue);
            this.binaryValue(model.binaryValue);
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue == null ? null : this.binaryValue.asByteBuffer();
        }

        @Override
        public final Builder binaryValue(SdkBytes binaryValue) {
            this.binaryValue = binaryValue;
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue(binaryValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)binaryValue));
        }

        public MessageAttributeValue build() {
            return new MessageAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageAttributeValue> {
        public Builder dataType(String var1);

        public Builder stringValue(String var1);

        public Builder binaryValue(SdkBytes var1);
    }
}

