/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LanguageCodeString {
    EN_US("en-US"),
    EN_GB("en-GB"),
    ES_419("es-419"),
    ES_ES("es-ES"),
    DE_DE("de-DE"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    IT_IT("it-IT"),
    JA_JP("ja-JP"),
    PT_BR("pt-BR"),
    KR_KR("kr-KR"),
    ZH_CN("zh-CN"),
    ZH_TW("zh-TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LanguageCodeString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCodeString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LanguageCodeString.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCodeString> knownValues() {
        return Stream.of(LanguageCodeString.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

