/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmSubscriptionRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, ConfirmSubscriptionRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(ConfirmSubscriptionRequest.getter(ConfirmSubscriptionRequest::topicArn)).setter(ConfirmSubscriptionRequest.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(ConfirmSubscriptionRequest.getter(ConfirmSubscriptionRequest::token)).setter(ConfirmSubscriptionRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final SdkField<String> AUTHENTICATE_ON_UNSUBSCRIBE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticateOnUnsubscribe").getter(ConfirmSubscriptionRequest.getter(ConfirmSubscriptionRequest::authenticateOnUnsubscribe)).setter(ConfirmSubscriptionRequest.setter(Builder::authenticateOnUnsubscribe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateOnUnsubscribe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, TOKEN_FIELD, AUTHENTICATE_ON_UNSUBSCRIBE_FIELD));
    private final String topicArn;
    private final String token;
    private final String authenticateOnUnsubscribe;

    private ConfirmSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.token = builder.token;
        this.authenticateOnUnsubscribe = builder.authenticateOnUnsubscribe;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String token() {
        return this.token;
    }

    public final String authenticateOnUnsubscribe() {
        return this.authenticateOnUnsubscribe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateOnUnsubscribe());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmSubscriptionRequest)) {
            return false;
        }
        ConfirmSubscriptionRequest other = (ConfirmSubscriptionRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.authenticateOnUnsubscribe(), other.authenticateOnUnsubscribe());
    }

    public final String toString() {
        return ToString.builder((String)"ConfirmSubscriptionRequest").add("TopicArn", (Object)this.topicArn()).add("Token", (Object)this.token()).add("AuthenticateOnUnsubscribe", (Object)this.authenticateOnUnsubscribe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "AuthenticateOnUnsubscribe": {
                return Optional.ofNullable(clazz.cast(this.authenticateOnUnsubscribe()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmSubscriptionRequest, T> g) {
        return obj -> g.apply((ConfirmSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String token;
        private String authenticateOnUnsubscribe;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmSubscriptionRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.token(model.token);
            this.authenticateOnUnsubscribe(model.authenticateOnUnsubscribe);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getAuthenticateOnUnsubscribe() {
            return this.authenticateOnUnsubscribe;
        }

        @Override
        public final Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
            return this;
        }

        public final void setAuthenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmSubscriptionRequest build() {
            return new ConfirmSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfirmSubscriptionRequest> {
        public Builder topicArn(String var1);

        public Builder token(String var1);

        public Builder authenticateOnUnsubscribe(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

