/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;
import software.amazon.awssdk.services.sns.model.SubscriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscriptionsByTopicResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscriptions").getter(ListSubscriptionsByTopicResponse.getter(ListSubscriptionsByTopicResponse::subscriptions)).setter(ListSubscriptionsByTopicResponse.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSubscriptionsByTopicResponse.getter(ListSubscriptionsByTopicResponse::nextToken)).setter(ListSubscriptionsByTopicResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Subscription> subscriptions;
    private final String nextToken;

    private ListSubscriptionsByTopicResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicResponse)) {
            return false;
        }
        ListSubscriptionsByTopicResponse other = (ListSubscriptionsByTopicResponse)((Object)obj);
        return this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSubscriptionsByTopicResponse").add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionsByTopicResponse, T> g) {
        return obj -> g.apply((ListSubscriptionsByTopicResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsByTopicResponse model) {
            super(model);
            this.subscriptions(model.subscriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            if (this.subscriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copyFromBuilder(subscriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscriptionsByTopicResponse build() {
            return new ListSubscriptionsByTopicResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

