/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPermissionRequest extends SnsRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddPermissionRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddPermissionRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AddPermissionRequest::awsAccountIds))
            .setter(setter(Builder::awsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AddPermissionRequest::actionNames))
            .setter(setter(Builder::actionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, LABEL_FIELD,
            AWS_ACCOUNT_IDS_FIELD, ACTION_NAMES_FIELD));

    private final String topicArn;

    private final String label;

    private final List<String> awsAccountIds;

    private final List<String> actionNames;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actionNames = builder.actionNames;
    }

    /**
     * <p>
     * The ARN of the topic whose access control policy you wish to modify.
     * </p>
     * 
     * @return The ARN of the topic whose access control policy you wish to modify.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * A unique identifier for the new policy statement.
     * </p>
     * 
     * @return A unique identifier for the new policy statement.
     */
    public String label() {
        return label;
    }

    /**
     * Returns true if the AWSAccountIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAwsAccountIds() {
        return awsAccountIds != null && !(awsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users must
     * have AWS accounts, but do not need to be signed up for this service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS account IDs of the users (principals) who will be given access to the specified actions. The
     *         users must have AWS accounts, but do not need to be signed up for this service.
     */
    public List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * Returns true if the ActionNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActionNames() {
        return actionNames != null && !(actionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action you want to allow for the specified principal(s).
     * </p>
     * <p>
     * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The action you want to allow for the specified principal(s).</p>
     *         <p>
     *         Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
     */
    public List<String> actionNames() {
        return actionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountIds());
        hashCode = 31 * hashCode + Objects.hashCode(actionNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(label(), other.label())
                && Objects.equals(awsAccountIds(), other.awsAccountIds()) && Objects.equals(actionNames(), other.actionNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddPermissionRequest").add("TopicArn", topicArn()).add("Label", label())
                .add("AWSAccountIds", awsAccountIds()).add("ActionNames", actionNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "AWSAccountIds":
            return Optional.ofNullable(clazz.cast(awsAccountIds()));
        case "ActionNames":
            return Optional.ofNullable(clazz.cast(actionNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The ARN of the topic whose access control policy you wish to modify.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic whose access control policy you wish to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * A unique identifier for the new policy statement.
         * </p>
         * 
         * @param label
         *        A unique identifier for the new policy statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users
         * must have AWS accounts, but do not need to be signed up for this service.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account IDs of the users (principals) who will be given access to the specified actions. The
         *        users must have AWS accounts, but do not need to be signed up for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users
         * must have AWS accounts, but do not need to be signed up for this service.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account IDs of the users (principals) who will be given access to the specified actions. The
         *        users must have AWS accounts, but do not need to be signed up for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String label;

        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            topicArn(model.topicArn);
            label(model.label);
            awsAccountIds(model.awsAccountIds);
            actionNames(model.actionNames);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAwsAccountIds() {
            return awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getActionNames() {
            return actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
