/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the <code>ListPhoneNumbersOptedOut</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersOptedOutResponse extends SnsResponse implements
        ToCopyableBuilder<ListPhoneNumbersOptedOutResponse.Builder, ListPhoneNumbersOptedOutResponse> {
    private static final SdkField<List<String>> PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPhoneNumbersOptedOutResponse::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPhoneNumbersOptedOutResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> phoneNumbers;

    private final String nextToken;

    private ListPhoneNumbersOptedOutResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PhoneNumbers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page can
     * contain up to 100 phone numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
     *         page can contain up to 100 phone numbers.
     */
    public List<String> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * <p>
     * A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code> action if
     * additional records are available after the first page of results.
     * </p>
     * 
     * @return A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code>
     *         action if additional records are available after the first page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersOptedOutResponse)) {
            return false;
        }
        ListPhoneNumbersOptedOutResponse other = (ListPhoneNumbersOptedOutResponse) obj;
        return Objects.equals(phoneNumbers(), other.phoneNumbers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPhoneNumbersOptedOutResponse").add("PhoneNumbers", phoneNumbers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersOptedOutResponse, T> g) {
        return obj -> g.apply((ListPhoneNumbersOptedOutResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
        /**
         * <p>
         * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page
         * can contain up to 100 phone numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
         *        page can contain up to 100 phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<String> phoneNumbers);

        /**
         * <p>
         * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page
         * can contain up to 100 phone numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
         *        page can contain up to 100 phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(String... phoneNumbers);

        /**
         * <p>
         * A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code> action if
         * additional records are available after the first page of results.
         * </p>
         * 
         * @param nextToken
         *        A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code>
         *        action if additional records are available after the first page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private List<String> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersOptedOutResponse model) {
            super(model);
            phoneNumbers(model.phoneNumbers);
            nextToken(model.nextToken);
        }

        public final Collection<String> getPhoneNumbers() {
            return phoneNumbers;
        }

        @Override
        public final Builder phoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(String... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        public final void setPhoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersOptedOutResponse build() {
            return new ListPhoneNumbersOptedOutResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
