/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.sns.SNSAsyncClient;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public class ListPlatformApplicationsPublisher
implements SdkPublisher<ListPlatformApplicationsResponse> {
    private final SNSAsyncClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlatformApplicationsPublisher(SNSAsyncClient client, ListPlatformApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlatformApplicationsPublisher(SNSAsyncClient client, ListPlatformApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlatformApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformApplications() != null) {
                return response.platformApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListPlatformApplicationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListPlatformApplicationsPublisher resume(ListPlatformApplicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPlatformApplicationsPublisher(this.client, (ListPlatformApplicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPlatformApplicationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPlatformApplicationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPlatformApplicationsResponseFetcher
    implements AsyncPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListPlatformApplicationsResponse> nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsPublisher.this.client.listPlatformApplications(ListPlatformApplicationsPublisher.this.firstRequest);
            }
            return ListPlatformApplicationsPublisher.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

