/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sns.model.SNSResponse;
import software.amazon.awssdk.services.sns.model.TopicAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTopicAttributesResponse
extends SNSResponse
implements ToCopyableBuilder<Builder, GetTopicAttributesResponse> {
    private final Map<String, String> attributes;

    private GetTopicAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicAttributesResponse)) {
            return false;
        }
        GetTopicAttributesResponse other = (GetTopicAttributesResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"GetTopicAttributesResponse").add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSResponse.BuilderImpl
    implements Builder {
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicAttributesResponse model) {
            this.attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = TopicAttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = TopicAttributesMapCopier.copy(attributes);
        }

        @Override
        public GetTopicAttributesResponse build() {
            return new GetTopicAttributesResponse(this);
        }
    }

    public static interface Builder
    extends SNSResponse.Builder,
    CopyableBuilder<Builder, GetTopicAttributesResponse> {
        public Builder attributes(Map<String, String> var1);
    }
}

