/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public final class ListPlatformApplicationsPaginator
implements SdkIterable<ListPlatformApplicationsResponse> {
    private final SNSClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPlatformApplicationsPaginator(SNSClient client, ListPlatformApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public Iterator<ListPlatformApplicationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> response != null ? response.platformApplications().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListPlatformApplicationsResponseFetcher
    implements NextPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPlatformApplicationsResponse nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsPaginator.this.client.listPlatformApplications(ListPlatformApplicationsPaginator.this.firstRequest);
            }
            return ListPlatformApplicationsPaginator.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

