/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformApplication
implements ToCopyableBuilder<Builder, PlatformApplication> {
    private final String platformApplicationArn;
    private final Map<String, String> attributes;

    private PlatformApplication(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    public String platformApplicationArn() {
        return this.platformApplicationArn;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformApplication)) {
            return false;
        }
        PlatformApplication other = (PlatformApplication)obj;
        return Objects.equals(this.platformApplicationArn(), other.platformApplicationArn()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(this.platformApplicationArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplicationArn": {
                return Optional.of(clazz.cast(this.platformApplicationArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String platformApplicationArn;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformApplication model) {
            this.platformApplicationArn(model.platformApplicationArn);
            this.attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return this.platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public PlatformApplication build() {
            return new PlatformApplication(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformApplication> {
        public Builder platformApplicationArn(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

