/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sns.model.SNSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfirmSubscriptionRequest
extends SNSRequest
implements ToCopyableBuilder<Builder, ConfirmSubscriptionRequest> {
    private final String topicArn;
    private final String token;
    private final String authenticateOnUnsubscribe;

    private ConfirmSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.token = builder.token;
        this.authenticateOnUnsubscribe = builder.authenticateOnUnsubscribe;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String token() {
        return this.token;
    }

    public String authenticateOnUnsubscribe() {
        return this.authenticateOnUnsubscribe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateOnUnsubscribe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmSubscriptionRequest)) {
            return false;
        }
        ConfirmSubscriptionRequest other = (ConfirmSubscriptionRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.authenticateOnUnsubscribe(), other.authenticateOnUnsubscribe());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.authenticateOnUnsubscribe() != null) {
            sb.append("AuthenticateOnUnsubscribe: ").append(this.authenticateOnUnsubscribe()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
            case "AuthenticateOnUnsubscribe": {
                return Optional.of(clazz.cast(this.authenticateOnUnsubscribe()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String token;
        private String authenticateOnUnsubscribe;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmSubscriptionRequest model) {
            this.topicArn(model.topicArn);
            this.token(model.token);
            this.authenticateOnUnsubscribe(model.authenticateOnUnsubscribe);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getAuthenticateOnUnsubscribe() {
            return this.authenticateOnUnsubscribe;
        }

        @Override
        public final Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
            return this;
        }

        public final void setAuthenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ConfirmSubscriptionRequest build() {
            return new ConfirmSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends SNSRequest.Builder,
    CopyableBuilder<Builder, ConfirmSubscriptionRequest> {
        public Builder topicArn(String var1);

        public Builder token(String var1);

        public Builder authenticateOnUnsubscribe(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

