/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetEndpointAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetEndpointAttributesRequest> {
    private final String endpointArn;
    private final Map<String, String> attributes;

    private SetEndpointAttributesRequest(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.attributes = builder.attributes;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetEndpointAttributesRequest)) {
            return false;
        }
        SetEndpointAttributesRequest other = (SetEndpointAttributesRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.endpointArn() != null) {
            sb.append("EndpointArn: ").append(this.endpointArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.of(clazz.cast(this.endpointArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SetEndpointAttributesRequest model) {
            this.endpointArn(model.endpointArn);
            this.attributes(model.attributes);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public SetEndpointAttributesRequest build() {
            return new SetEndpointAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetEndpointAttributesRequest> {
        public Builder endpointArn(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

