/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlatformEndpointRequest> {
    private final String platformApplicationArn;
    private final String token;
    private final String customUserData;
    private final Map<String, String> attributes;

    private CreatePlatformEndpointRequest(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.token = builder.token;
        this.customUserData = builder.customUserData;
        this.attributes = builder.attributes;
    }

    public String platformApplicationArn() {
        return this.platformApplicationArn;
    }

    public String token() {
        return this.token;
    }

    public String customUserData() {
        return this.customUserData;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.customUserData());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointRequest)) {
            return false;
        }
        CreatePlatformEndpointRequest other = (CreatePlatformEndpointRequest)((Object)obj);
        return Objects.equals(this.platformApplicationArn(), other.platformApplicationArn()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.customUserData(), other.customUserData()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(this.platformApplicationArn()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.customUserData() != null) {
            sb.append("CustomUserData: ").append(this.customUserData()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplicationArn": {
                return Optional.of(clazz.cast(this.platformApplicationArn()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
            case "CustomUserData": {
                return Optional.of(clazz.cast(this.customUserData()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String platformApplicationArn;
        private String token;
        private String customUserData;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointRequest model) {
            this.platformApplicationArn(model.platformApplicationArn);
            this.token(model.token);
            this.customUserData(model.customUserData);
            this.attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return this.platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getCustomUserData() {
            return this.customUserData;
        }

        @Override
        public final Builder customUserData(String customUserData) {
            this.customUserData = customUserData;
            return this;
        }

        public final void setCustomUserData(String customUserData) {
            this.customUserData = customUserData;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public CreatePlatformEndpointRequest build() {
            return new CreatePlatformEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlatformEndpointRequest> {
        public Builder platformApplicationArn(String var1);

        public Builder token(String var1);

        public Builder customUserData(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

