/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscription
implements ToCopyableBuilder<Builder, Subscription> {
    private final String subscriptionArn;
    private final String owner;
    private final String protocol;
    private final String endpoint;
    private final String topicArn;

    private Subscription(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.owner = builder.owner;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
        this.topicArn = builder.topicArn;
    }

    public String subscriptionArn() {
        return this.subscriptionArn;
    }

    public String owner() {
        return this.owner;
    }

    public String protocol() {
        return this.protocol;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionArn() == null ? 0 : this.subscriptionArn().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (other.subscriptionArn() == null ^ this.subscriptionArn() == null) {
            return false;
        }
        if (other.subscriptionArn() != null && !other.subscriptionArn().equals(this.subscriptionArn())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        return other.topicArn() == null || other.topicArn().equals(this.topicArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(this.subscriptionArn()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.of(clazz.cast(this.subscriptionArn()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String owner;
        private String protocol;
        private String endpoint;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionArn(model.subscriptionArn);
            this.owner(model.owner);
            this.protocol(model.protocol);
            this.endpoint(model.endpoint);
            this.topicArn(model.topicArn);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionArn(String var1);

        public Builder owner(String var1);

        public Builder protocol(String var1);

        public Builder endpoint(String var1);

        public Builder topicArn(String var1);
    }
}

