/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.ListStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSMSAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSMSAttributesRequest> {
    private final List<String> attributes;

    private GetSMSAttributesRequest(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    public List<String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSMSAttributesRequest)) {
            return false;
        }
        GetSMSAttributesRequest other = (GetSMSAttributesRequest)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSMSAttributesRequest model) {
            this.attributes(model.attributes);
        }

        public final Collection<String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
        }

        public GetSMSAttributesRequest build() {
            return new GetSMSAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSMSAttributesRequest> {
        public Builder attributes(Collection<String> var1);

        public Builder attributes(String ... var1);
    }
}

