/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.nio.ByteBuffer;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.util.StringUtils;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        Map<String, MessageAttributeValue> messageAttributes;
        if (publishRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishRequest, "SNSClient");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)publishRequest.topicArn()));
        }
        if (publishRequest.targetArn() != null) {
            request.addParameter("TargetArn", StringUtils.fromString((String)publishRequest.targetArn()));
        }
        if (publishRequest.phoneNumber() != null) {
            request.addParameter("PhoneNumber", StringUtils.fromString((String)publishRequest.phoneNumber()));
        }
        if (publishRequest.message() != null) {
            request.addParameter("Message", StringUtils.fromString((String)publishRequest.message()));
        }
        if (publishRequest.subject() != null) {
            request.addParameter("Subject", StringUtils.fromString((String)publishRequest.subject()));
        }
        if (publishRequest.messageStructure() != null) {
            request.addParameter("MessageStructure", StringUtils.fromString((String)publishRequest.messageStructure()));
        }
        if ((messageAttributes = publishRequest.messageAttributes()) != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    if (entry.getValue().dataType() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().dataType()));
                    }
                    if (entry.getValue().stringValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().stringValue()));
                    }
                    if (entry.getValue().binaryValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().binaryValue()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        return request;
    }
}

