/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListTopicsRequestMarshaller
implements Marshaller<Request<ListTopicsRequest>, ListTopicsRequest> {
    public Request<ListTopicsRequest> marshall(ListTopicsRequest listTopicsRequest) {
        if (listTopicsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTopicsRequest, "SNSClient");
        request.addParameter("Action", "ListTopics");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTopicsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listTopicsRequest.nextToken()));
        }
        return request;
    }
}

