/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.sns.model.Subscription;
import software.amazon.awssdk.services.sns.model.SubscriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSubscriptionsByTopicResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
    private final List<Subscription> subscriptions;
    private final String nextToken;

    private ListSubscriptionsByTopicResponse(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptions() == null ? 0 : this.subscriptions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicResponse)) {
            return false;
        }
        ListSubscriptionsByTopicResponse other = (ListSubscriptionsByTopicResponse)((Object)obj);
        if (other.subscriptions() == null ^ this.subscriptions() == null) {
            return false;
        }
        if (other.subscriptions() != null && !other.subscriptions().equals(this.subscriptions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptions() != null) {
            sb.append("Subscriptions: ").append(this.subscriptions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsByTopicResponse model) {
            this.setSubscriptions(model.subscriptions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListSubscriptionsByTopicResponse build() {
            return new ListSubscriptionsByTopicResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder nextToken(String var1);
    }
}

