/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import software.amazon.awssdk.utils.Base64Utils;

public class SignatureChecker {
    private static final String NOTIFICATION_TYPE = "Notification";
    private static final String SUBSCRIBE_TYPE = "SubscriptionConfirmation";
    private static final String UNSUBSCRIBE_TYPE = "UnsubscribeConfirmation";
    private static final String TYPE = "Type";
    private static final String SUBSCRIBE_URL = "SubscribeURL";
    private static final String MESSAGE = "Message";
    private static final String TIMESTAMP = "Timestamp";
    private static final String SIGNATURE_VERSION = "SignatureVersion";
    private static final String SIGNATURE = "Signature";
    private static final String MESSAGE_ID = "MessageId";
    private static final String SUBJECT = "Subject";
    private static final String TOPIC = "TopicArn";
    private static final String TOKEN = "Token";
    private static final Set<String> INTERESTING_FIELDS = new HashSet<String>(Arrays.asList("Type", "SubscribeURL", "Message", "Timestamp", "Signature", "SignatureVersion", "MessageId", "Subject", "TopicArn", "Token"));
    private Signature sigChecker;

    public boolean verifyMessageSignature(String message, PublicKey publicKey) {
        Map<String, String> parsed = this.parseJson(message);
        return this.verifySignature(parsed, publicKey);
    }

    public boolean verifySignature(Map<String, String> parsedMessage, PublicKey publicKey) {
        boolean valid = false;
        String version = parsedMessage.get(SIGNATURE_VERSION);
        if (version.equals("1")) {
            String type = parsedMessage.get(TYPE);
            String signature = parsedMessage.get(SIGNATURE);
            String signed = "";
            if (type.equals(NOTIFICATION_TYPE)) {
                signed = this.stringToSign(this.publishMessageValues(parsedMessage));
            } else if (type.equals(SUBSCRIBE_TYPE)) {
                signed = this.stringToSign(this.subscribeMessageValues(parsedMessage));
            } else if (type.equals(UNSUBSCRIBE_TYPE)) {
                signed = this.stringToSign(this.subscribeMessageValues(parsedMessage));
            } else {
                throw new RuntimeException("Cannot process message of type " + type);
            }
            valid = this.verifySignature(signed, signature, publicKey);
        }
        return valid;
    }

    public boolean verifySignature(String message, String signature, PublicKey publicKey) {
        boolean result = false;
        byte[] sigbytes = null;
        try {
            sigbytes = Base64Utils.decode((byte[])signature.getBytes());
            this.sigChecker = Signature.getInstance("SHA1withRSA");
            this.sigChecker.initVerify(publicKey);
            this.sigChecker.update(message.getBytes());
            result = this.sigChecker.verify(sigbytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return result;
    }

    protected String stringToSign(SortedMap<String, String> signables) {
        StringBuilder sb = new StringBuilder();
        for (String k : signables.keySet()) {
            sb.append(k).append("\n");
            sb.append((String)signables.get(k)).append("\n");
        }
        String result = sb.toString();
        return result;
    }

    private Map<String, String> parseJson(String jsonmessage) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        JsonFactory jf = new JsonFactory();
        try {
            JsonParser parser = jf.createParser(jsonmessage);
            parser.nextToken();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String value;
                String fieldname = parser.getCurrentName();
                if (!INTERESTING_FIELDS.contains(fieldname)) {
                    parser.skipChildren();
                    continue;
                }
                parser.nextToken();
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    value = "";
                    boolean first = true;
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        if (!first) {
                            value = value + ",";
                        }
                        first = false;
                        value = value + parser.getText();
                    }
                } else {
                    value = parser.getText();
                }
                parsed.put(fieldname, value);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return parsed;
    }

    private TreeMap<String, String> publishMessageValues(Map<String, String> parsedMessage) {
        String[] keys;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys = new String[]{MESSAGE, MESSAGE_ID, SUBJECT, TYPE, TIMESTAMP, TOPIC}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }

    private TreeMap<String, String> subscribeMessageValues(Map<String, String> parsedMessage) {
        String[] keys;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys = new String[]{SUBSCRIBE_URL, MESSAGE, MESSAGE_ID, TYPE, TIMESTAMP, TOKEN, TOPIC}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }
}

