/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;

public class UnsubscribeRequestMarshaller
implements Marshaller<Request<UnsubscribeRequest>, UnsubscribeRequest> {
    public Request<UnsubscribeRequest> marshall(UnsubscribeRequest unsubscribeRequest) {
        if (unsubscribeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)unsubscribeRequest, "SnsClient");
        request.addParameter("Action", "Unsubscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (unsubscribeRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringConversion.fromString((String)unsubscribeRequest.subscriptionArn()));
        }
        return request;
    }
}

