/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;

public class SetTopicAttributesRequestMarshaller
implements Marshaller<Request<SetTopicAttributesRequest>, SetTopicAttributesRequest> {
    public Request<SetTopicAttributesRequest> marshall(SetTopicAttributesRequest setTopicAttributesRequest) {
        if (setTopicAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setTopicAttributesRequest, "SnsClient");
        request.addParameter("Action", "SetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setTopicAttributesRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)setTopicAttributesRequest.topicArn()));
        }
        if (setTopicAttributesRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringConversion.fromString((String)setTopicAttributesRequest.attributeName()));
        }
        if (setTopicAttributesRequest.attributeValue() != null) {
            request.addParameter("AttributeValue", StringConversion.fromString((String)setTopicAttributesRequest.attributeValue()));
        }
        return request;
    }
}

