/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;

public class ListTopicsRequestMarshaller
implements Marshaller<Request<ListTopicsRequest>, ListTopicsRequest> {
    public Request<ListTopicsRequest> marshall(ListTopicsRequest listTopicsRequest) {
        if (listTopicsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listTopicsRequest, "SNSClient");
        request.addParameter("Action", "ListTopics");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTopicsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listTopicsRequest.nextToken()));
        }
        return request;
    }
}

