/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.sns.SNSAsyncClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsByTopicPublisher
implements SdkPublisher<ListSubscriptionsByTopicResponse> {
    private final SNSAsyncClient client;
    private final ListSubscriptionsByTopicRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionsByTopicPublisher(SNSAsyncClient client, ListSubscriptionsByTopicRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionsByTopicPublisher(SNSAsyncClient client, ListSubscriptionsByTopicRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionsByTopicResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscriptionsByTopicResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Subscription> subscriptions() {
        Function<ListSubscriptionsByTopicResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListSubscriptionsByTopicResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListSubscriptionsByTopicPublisher resume(ListSubscriptionsByTopicResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSubscriptionsByTopicPublisher(this.client, (ListSubscriptionsByTopicRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSubscriptionsByTopicPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSubscriptionsByTopicResponse> subscriber) {
                subscriber.onSubscribe((org.reactivestreams.Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSubscriptionsByTopicResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionsByTopicResponse> {
        private ListSubscriptionsByTopicResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsByTopicResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListSubscriptionsByTopicResponse> nextPage(ListSubscriptionsByTopicResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsByTopicPublisher.this.client.listSubscriptionsByTopic(ListSubscriptionsByTopicPublisher.this.firstRequest);
            }
            return ListSubscriptionsByTopicPublisher.this.client.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)((Object)ListSubscriptionsByTopicPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

