/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.services.sns.model.SNSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetEndpointAttributesRequest
extends SNSRequest
implements ToCopyableBuilder<Builder, SetEndpointAttributesRequest> {
    private final String endpointArn;
    private final Map<String, String> attributes;

    private SetEndpointAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.attributes = builder.attributes;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetEndpointAttributesRequest)) {
            return false;
        }
        SetEndpointAttributesRequest other = (SetEndpointAttributesRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"SetEndpointAttributesRequest").add("EndpointArn", (Object)this.endpointArn()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.of(clazz.cast(this.endpointArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSRequest.BuilderImpl
    implements Builder {
        private String endpointArn;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SetEndpointAttributesRequest model) {
            super(model);
            this.endpointArn(model.endpointArn);
            this.attributes(model.attributes);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetEndpointAttributesRequest build() {
            return new SetEndpointAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SNSRequest.Builder,
    CopyableBuilder<Builder, SetEndpointAttributesRequest> {
        public Builder endpointArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

