/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteTopicRequestMarshaller
implements Marshaller<Request<DeleteTopicRequest>, DeleteTopicRequest> {
    public Request<DeleteTopicRequest> marshall(DeleteTopicRequest deleteTopicRequest) {
        if (deleteTopicRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTopicRequest, "SNSClient");
        request.addParameter("Action", "DeleteTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteTopicRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)deleteTopicRequest.topicArn()));
        }
        return request;
    }
}

