/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreatePlatformApplicationRequestMarshaller
implements Marshaller<Request<CreatePlatformApplicationRequest>, CreatePlatformApplicationRequest> {
    public Request<CreatePlatformApplicationRequest> marshall(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        if (createPlatformApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformApplicationRequest, "SNSClient");
        request.addParameter("Action", "CreatePlatformApplication");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformApplicationRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createPlatformApplicationRequest.name()));
        }
        if (createPlatformApplicationRequest.platform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)createPlatformApplicationRequest.platform()));
        }
        Map<String, String> attributes = createPlatformApplicationRequest.attributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

