/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.util.StringUtils;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        SdkInternalList actionNamesList;
        SdkInternalList aWSAccountIdsList;
        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "SNSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)addPermissionRequest.topicArn()));
        }
        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString((String)addPermissionRequest.label()));
        }
        if (!(aWSAccountIdsList = (SdkInternalList)addPermissionRequest.awsAccountIds()).isEmpty() || !aWSAccountIdsList.isAutoConstruct()) {
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringUtils.fromString((String)aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (!(actionNamesList = (SdkInternalList)addPermissionRequest.actionNames()).isEmpty() || !actionNamesList.isAutoConstruct()) {
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionName.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        return request;
    }
}

