/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlatformEndpointRequest> {
    private final String platformApplicationArn;
    private final String token;
    private final String customUserData;
    private final Map<String, String> attributes;

    private CreatePlatformEndpointRequest(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.token = builder.token;
        this.customUserData = builder.customUserData;
        this.attributes = builder.attributes;
    }

    public String platformApplicationArn() {
        return this.platformApplicationArn;
    }

    public String token() {
        return this.token;
    }

    public String customUserData() {
        return this.customUserData;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformApplicationArn() == null ? 0 : this.platformApplicationArn().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        hashCode = 31 * hashCode + (this.customUserData() == null ? 0 : this.customUserData().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointRequest)) {
            return false;
        }
        CreatePlatformEndpointRequest other = (CreatePlatformEndpointRequest)((Object)obj);
        if (other.platformApplicationArn() == null ^ this.platformApplicationArn() == null) {
            return false;
        }
        if (other.platformApplicationArn() != null && !other.platformApplicationArn().equals(this.platformApplicationArn())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        if (other.customUserData() == null ^ this.customUserData() == null) {
            return false;
        }
        if (other.customUserData() != null && !other.customUserData().equals(this.customUserData())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(this.platformApplicationArn()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.customUserData() != null) {
            sb.append("CustomUserData: ").append(this.customUserData()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String platformApplicationArn;
        private String token;
        private String customUserData;
        private Map<String, String> attributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointRequest model) {
            this.setPlatformApplicationArn(model.platformApplicationArn);
            this.setToken(model.token);
            this.setCustomUserData(model.customUserData);
            this.setAttributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return this.platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getCustomUserData() {
            return this.customUserData;
        }

        @Override
        public final Builder customUserData(String customUserData) {
            this.customUserData = customUserData;
            return this;
        }

        public final void setCustomUserData(String customUserData) {
            this.customUserData = customUserData;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public CreatePlatformEndpointRequest build() {
            return new CreatePlatformEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlatformEndpointRequest> {
        public Builder platformApplicationArn(String var1);

        public Builder token(String var1);

        public Builder customUserData(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

