/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.snowdevicemanagement.model.Reboot;
import software.amazon.awssdk.services.snowdevicemanagement.model.Unlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Command
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Command> {
    private static final SdkField<Reboot> REBOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reboot").getter(Command.getter(Command::reboot)).setter(Command.setter(Builder::reboot)).constructor(Reboot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reboot").build()}).build();
    private static final SdkField<Unlock> UNLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unlock").getter(Command.getter(Command::unlock)).setter(Command.setter(Builder::unlock)).constructor(Unlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBOOT_FIELD, UNLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Command.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Reboot reboot;
    private final Unlock unlock;
    private final Type type;

    private Command(BuilderImpl builder) {
        this.reboot = builder.reboot;
        this.unlock = builder.unlock;
        this.type = builder.type;
    }

    public final Reboot reboot() {
        return this.reboot;
    }

    public final Unlock unlock() {
        return this.unlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reboot());
        hashCode = 31 * hashCode + Objects.hashCode(this.unlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        return Objects.equals(this.reboot(), other.reboot()) && Objects.equals(this.unlock(), other.unlock());
    }

    public final String toString() {
        return ToString.builder((String)"Command").add("Reboot", (Object)this.reboot()).add("Unlock", (Object)this.unlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reboot": {
                return Optional.ofNullable(clazz.cast(this.reboot()));
            }
            case "unlock": {
                return Optional.ofNullable(clazz.cast(this.unlock()));
            }
        }
        return Optional.empty();
    }

    public static Command fromReboot(Reboot reboot) {
        return (Command)Command.builder().reboot(reboot).build();
    }

    public static Command fromReboot(Consumer<Reboot.Builder> reboot) {
        Reboot.Builder builder = Reboot.builder();
        reboot.accept(builder);
        return Command.fromReboot((Reboot)builder.build());
    }

    public static Command fromUnlock(Unlock unlock) {
        return (Command)Command.builder().unlock(unlock).build();
    }

    public static Command fromUnlock(Consumer<Unlock.Builder> unlock) {
        Unlock.Builder builder = Unlock.builder();
        unlock.accept(builder);
        return Command.fromUnlock((Unlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reboot", REBOOT_FIELD);
        map.put("unlock", UNLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REBOOT,
        UNLOCK,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Reboot reboot;
        private Unlock unlock;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.reboot(model.reboot);
            this.unlock(model.unlock);
        }

        public final Reboot.Builder getReboot() {
            return this.reboot != null ? this.reboot.toBuilder() : null;
        }

        public final void setReboot(Reboot.BuilderImpl reboot) {
            Reboot oldValue = this.reboot;
            this.reboot = reboot != null ? reboot.build() : null;
            this.handleUnionValueChange(Type.REBOOT, oldValue, this.reboot);
        }

        @Override
        public final Builder reboot(Reboot reboot) {
            Reboot oldValue = this.reboot;
            this.reboot = reboot;
            this.handleUnionValueChange(Type.REBOOT, oldValue, this.reboot);
            return this;
        }

        public final Unlock.Builder getUnlock() {
            return this.unlock != null ? this.unlock.toBuilder() : null;
        }

        public final void setUnlock(Unlock.BuilderImpl unlock) {
            Unlock oldValue = this.unlock;
            this.unlock = unlock != null ? unlock.build() : null;
            this.handleUnionValueChange(Type.UNLOCK, oldValue, this.unlock);
        }

        @Override
        public final Builder unlock(Unlock unlock) {
            Unlock oldValue = this.unlock;
            this.unlock = unlock;
            this.handleUnionValueChange(Type.UNLOCK, oldValue, this.unlock);
            return this;
        }

        public Command build() {
            return new Command(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Command> {
        public Builder reboot(Reboot var1);

        default public Builder reboot(Consumer<Reboot.Builder> reboot) {
            return this.reboot((Reboot)((Reboot.Builder)Reboot.builder().applyMutation(reboot)).build());
        }

        public Builder unlock(Unlock var1);

        default public Builder unlock(Consumer<Unlock.Builder> unlock) {
            return this.unlock((Unlock)((Unlock.Builder)Unlock.builder().applyMutation(unlock)).build());
        }
    }
}

