/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSnowballUsageResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, GetSnowballUsageResponse> {
    private static final SdkField<Integer> SNOWBALL_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetSnowballUsageResponse.getter(GetSnowballUsageResponse::snowballLimit)).setter(GetSnowballUsageResponse.setter(Builder::snowballLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballLimit").build()}).build();
    private static final SdkField<Integer> SNOWBALLS_IN_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetSnowballUsageResponse.getter(GetSnowballUsageResponse::snowballsInUse)).setter(GetSnowballUsageResponse.setter(Builder::snowballsInUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballsInUse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNOWBALL_LIMIT_FIELD, SNOWBALLS_IN_USE_FIELD));
    private final Integer snowballLimit;
    private final Integer snowballsInUse;

    private GetSnowballUsageResponse(BuilderImpl builder) {
        super(builder);
        this.snowballLimit = builder.snowballLimit;
        this.snowballsInUse = builder.snowballsInUse;
    }

    public Integer snowballLimit() {
        return this.snowballLimit;
    }

    public Integer snowballsInUse() {
        return this.snowballsInUse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballsInUse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnowballUsageResponse)) {
            return false;
        }
        GetSnowballUsageResponse other = (GetSnowballUsageResponse)((Object)obj);
        return Objects.equals(this.snowballLimit(), other.snowballLimit()) && Objects.equals(this.snowballsInUse(), other.snowballsInUse());
    }

    public String toString() {
        return ToString.builder((String)"GetSnowballUsageResponse").add("SnowballLimit", (Object)this.snowballLimit()).add("SnowballsInUse", (Object)this.snowballsInUse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnowballLimit": {
                return Optional.ofNullable(clazz.cast(this.snowballLimit()));
            }
            case "SnowballsInUse": {
                return Optional.ofNullable(clazz.cast(this.snowballsInUse()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSnowballUsageResponse, T> g) {
        return obj -> g.apply((GetSnowballUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private Integer snowballLimit;
        private Integer snowballsInUse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnowballUsageResponse model) {
            super(model);
            this.snowballLimit(model.snowballLimit);
            this.snowballsInUse(model.snowballsInUse);
        }

        public final Integer getSnowballLimit() {
            return this.snowballLimit;
        }

        @Override
        public final Builder snowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
            return this;
        }

        public final void setSnowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
        }

        public final Integer getSnowballsInUse() {
            return this.snowballsInUse;
        }

        @Override
        public final Builder snowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
            return this;
        }

        public final void setSnowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
        }

        @Override
        public GetSnowballUsageResponse build() {
            return new GetSnowballUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSnowballUsageResponse> {
        public Builder snowballLimit(Integer var1);

        public Builder snowballsInUse(Integer var1);
    }
}

