/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.DeviceServiceName;
import software.amazon.awssdk.services.snowball.model.TransferOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetOnDeviceService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetOnDeviceService> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(TargetOnDeviceService.getter(TargetOnDeviceService::serviceNameAsString)).setter(TargetOnDeviceService.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> TRANSFER_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferOption").getter(TargetOnDeviceService.getter(TargetOnDeviceService::transferOptionAsString)).setter(TargetOnDeviceService.setter(Builder::transferOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, TRANSFER_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetOnDeviceService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final String transferOption;

    private TargetOnDeviceService(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.transferOption = builder.transferOption;
    }

    public final DeviceServiceName serviceName() {
        return DeviceServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public final TransferOption transferOption() {
        return TransferOption.fromValue(this.transferOption);
    }

    public final String transferOptionAsString() {
        return this.transferOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetOnDeviceService)) {
            return false;
        }
        TargetOnDeviceService other = (TargetOnDeviceService)obj;
        return Objects.equals(this.serviceNameAsString(), other.serviceNameAsString()) && Objects.equals(this.transferOptionAsString(), other.transferOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TargetOnDeviceService").add("ServiceName", (Object)this.serviceNameAsString()).add("TransferOption", (Object)this.transferOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
            case "TransferOption": {
                return Optional.ofNullable(clazz.cast(this.transferOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("TransferOption", TRANSFER_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetOnDeviceService, T> g) {
        return obj -> g.apply((TargetOnDeviceService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private String transferOption;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetOnDeviceService model) {
            this.serviceName(model.serviceName);
            this.transferOption(model.transferOption);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(DeviceServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final String getTransferOption() {
            return this.transferOption;
        }

        public final void setTransferOption(String transferOption) {
            this.transferOption = transferOption;
        }

        @Override
        public final Builder transferOption(String transferOption) {
            this.transferOption = transferOption;
            return this;
        }

        @Override
        public final Builder transferOption(TransferOption transferOption) {
            this.transferOption(transferOption == null ? null : transferOption.toString());
            return this;
        }

        public TargetOnDeviceService build() {
            return new TargetOnDeviceService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetOnDeviceService> {
        public Builder serviceName(String var1);

        public Builder serviceName(DeviceServiceName var1);

        public Builder transferOption(String var1);

        public Builder transferOption(TransferOption var1);
    }
}

