/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon S3 compatible storage on Snow family devices configuration items.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OnDeviceServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3OnDeviceServiceConfiguration.Builder, S3OnDeviceServiceConfiguration> {
    private static final SdkField<Double> STORAGE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StorageLimit").getter(getter(S3OnDeviceServiceConfiguration::storageLimit))
            .setter(setter(Builder::storageLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLimit").build()).build();

    private static final SdkField<String> STORAGE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageUnit").getter(getter(S3OnDeviceServiceConfiguration::storageUnitAsString))
            .setter(setter(Builder::storageUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageUnit").build()).build();

    private static final SdkField<Integer> SERVICE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServiceSize").getter(getter(S3OnDeviceServiceConfiguration::serviceSize))
            .setter(setter(Builder::serviceSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSize").build()).build();

    private static final SdkField<Integer> FAULT_TOLERANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FaultTolerance").getter(getter(S3OnDeviceServiceConfiguration::faultTolerance))
            .setter(setter(Builder::faultTolerance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultTolerance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LIMIT_FIELD,
            STORAGE_UNIT_FIELD, SERVICE_SIZE_FIELD, FAULT_TOLERANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double storageLimit;

    private final String storageUnit;

    private final Integer serviceSize;

    private final Integer faultTolerance;

    private S3OnDeviceServiceConfiguration(BuilderImpl builder) {
        this.storageLimit = builder.storageLimit;
        this.storageUnit = builder.storageUnit;
        this.serviceSize = builder.serviceSize;
        this.faultTolerance = builder.faultTolerance;
    }

    /**
     * <p>
     * If the specified storage limit value matches storage limit of one of the defined configurations, that
     * configuration will be used. If the specified storage limit value does not match any defined configuration, the
     * request will fail. If more than one configuration has the same storage limit as specified, the other input need
     * to be provided.
     * </p>
     * 
     * @return If the specified storage limit value matches storage limit of one of the defined configurations, that
     *         configuration will be used. If the specified storage limit value does not match any defined
     *         configuration, the request will fail. If more than one configuration has the same storage limit as
     *         specified, the other input need to be provided.
     */
    public final Double storageLimit() {
        return storageLimit;
    }

    /**
     * <p>
     * Storage unit. Currently the only supported unit is TB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageUnit} will
     * return {@link StorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageUnitAsString}.
     * </p>
     * 
     * @return Storage unit. Currently the only supported unit is TB.
     * @see StorageUnit
     */
    public final StorageUnit storageUnit() {
        return StorageUnit.fromValue(storageUnit);
    }

    /**
     * <p>
     * Storage unit. Currently the only supported unit is TB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageUnit} will
     * return {@link StorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageUnitAsString}.
     * </p>
     * 
     * @return Storage unit. Currently the only supported unit is TB.
     * @see StorageUnit
     */
    public final String storageUnitAsString() {
        return storageUnit;
    }

    /**
     * <p>
     * Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible storage on Snow
     * family devices. If specified, the other input can be omitted.
     * </p>
     * 
     * @return Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible storage
     *         on Snow family devices. If specified, the other input can be omitted.
     */
    public final Integer serviceSize() {
        return serviceSize;
    }

    /**
     * <p>
     * &gt;Fault tolerance level of the cluster. This indicates the number of nodes that can go down without degrading
     * the performance of the cluster. This additional input helps when the specified <code>StorageLimit</code> matches
     * more than one Amazon S3 compatible storage on Snow family devices service configuration.
     * </p>
     * 
     * @return &gt;Fault tolerance level of the cluster. This indicates the number of nodes that can go down without
     *         degrading the performance of the cluster. This additional input helps when the specified
     *         <code>StorageLimit</code> matches more than one Amazon S3 compatible storage on Snow family devices
     *         service configuration.
     */
    public final Integer faultTolerance() {
        return faultTolerance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(storageUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSize());
        hashCode = 31 * hashCode + Objects.hashCode(faultTolerance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OnDeviceServiceConfiguration)) {
            return false;
        }
        S3OnDeviceServiceConfiguration other = (S3OnDeviceServiceConfiguration) obj;
        return Objects.equals(storageLimit(), other.storageLimit())
                && Objects.equals(storageUnitAsString(), other.storageUnitAsString())
                && Objects.equals(serviceSize(), other.serviceSize()) && Objects.equals(faultTolerance(), other.faultTolerance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3OnDeviceServiceConfiguration").add("StorageLimit", storageLimit())
                .add("StorageUnit", storageUnitAsString()).add("ServiceSize", serviceSize())
                .add("FaultTolerance", faultTolerance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageLimit":
            return Optional.ofNullable(clazz.cast(storageLimit()));
        case "StorageUnit":
            return Optional.ofNullable(clazz.cast(storageUnitAsString()));
        case "ServiceSize":
            return Optional.ofNullable(clazz.cast(serviceSize()));
        case "FaultTolerance":
            return Optional.ofNullable(clazz.cast(faultTolerance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageLimit", STORAGE_LIMIT_FIELD);
        map.put("StorageUnit", STORAGE_UNIT_FIELD);
        map.put("ServiceSize", SERVICE_SIZE_FIELD);
        map.put("FaultTolerance", FAULT_TOLERANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3OnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((S3OnDeviceServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OnDeviceServiceConfiguration> {
        /**
         * <p>
         * If the specified storage limit value matches storage limit of one of the defined configurations, that
         * configuration will be used. If the specified storage limit value does not match any defined configuration,
         * the request will fail. If more than one configuration has the same storage limit as specified, the other
         * input need to be provided.
         * </p>
         * 
         * @param storageLimit
         *        If the specified storage limit value matches storage limit of one of the defined configurations, that
         *        configuration will be used. If the specified storage limit value does not match any defined
         *        configuration, the request will fail. If more than one configuration has the same storage limit as
         *        specified, the other input need to be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLimit(Double storageLimit);

        /**
         * <p>
         * Storage unit. Currently the only supported unit is TB.
         * </p>
         * 
         * @param storageUnit
         *        Storage unit. Currently the only supported unit is TB.
         * @see StorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageUnit
         */
        Builder storageUnit(String storageUnit);

        /**
         * <p>
         * Storage unit. Currently the only supported unit is TB.
         * </p>
         * 
         * @param storageUnit
         *        Storage unit. Currently the only supported unit is TB.
         * @see StorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageUnit
         */
        Builder storageUnit(StorageUnit storageUnit);

        /**
         * <p>
         * Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible storage on
         * Snow family devices. If specified, the other input can be omitted.
         * </p>
         * 
         * @param serviceSize
         *        Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible
         *        storage on Snow family devices. If specified, the other input can be omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSize(Integer serviceSize);

        /**
         * <p>
         * &gt;Fault tolerance level of the cluster. This indicates the number of nodes that can go down without
         * degrading the performance of the cluster. This additional input helps when the specified
         * <code>StorageLimit</code> matches more than one Amazon S3 compatible storage on Snow family devices service
         * configuration.
         * </p>
         * 
         * @param faultTolerance
         *        &gt;Fault tolerance level of the cluster. This indicates the number of nodes that can go down without
         *        degrading the performance of the cluster. This additional input helps when the specified
         *        <code>StorageLimit</code> matches more than one Amazon S3 compatible storage on Snow family devices
         *        service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultTolerance(Integer faultTolerance);
    }

    static final class BuilderImpl implements Builder {
        private Double storageLimit;

        private String storageUnit;

        private Integer serviceSize;

        private Integer faultTolerance;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OnDeviceServiceConfiguration model) {
            storageLimit(model.storageLimit);
            storageUnit(model.storageUnit);
            serviceSize(model.serviceSize);
            faultTolerance(model.faultTolerance);
        }

        public final Double getStorageLimit() {
            return storageLimit;
        }

        public final void setStorageLimit(Double storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Double storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getStorageUnit() {
            return storageUnit;
        }

        public final void setStorageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
        }

        @Override
        public final Builder storageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
            return this;
        }

        @Override
        public final Builder storageUnit(StorageUnit storageUnit) {
            this.storageUnit(storageUnit == null ? null : storageUnit.toString());
            return this;
        }

        public final Integer getServiceSize() {
            return serviceSize;
        }

        public final void setServiceSize(Integer serviceSize) {
            this.serviceSize = serviceSize;
        }

        @Override
        public final Builder serviceSize(Integer serviceSize) {
            this.serviceSize = serviceSize;
            return this;
        }

        public final Integer getFaultTolerance() {
            return faultTolerance;
        }

        public final void setFaultTolerance(Integer faultTolerance) {
            this.faultTolerance = faultTolerance;
        }

        @Override
        public final Builder faultTolerance(Integer faultTolerance) {
            this.faultTolerance = faultTolerance;
            return this;
        }

        @Override
        public S3OnDeviceServiceConfiguration build() {
            return new S3OnDeviceServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
